#ifndef __MY_TJI_H__
#define __MY_TJI_H__

/**
 *
 * \file        mytji.h
 *
 * \brief       Environment-specific customization header file for TJI.
 *
 * \author      Pete McCormick
 *
 * \date        6/21/2007
 *
 */

///////////////////////////////////////////////////////////////////////////////

#include "dm_nutypedefs.h"

///////////////////////////////////////////////////////////////////////////////

#define TJI_RESP_DEST_ID                0x02

///////////////////////////////////////////////////////////////////////////////
#define TJI_SUBTYPE_DIGITAL_INPUT       0x00
#define TJI_SUBTYPE_DIGITAL_OUTPUT		0x01
#define TJI_SUBTYPE_ANALOG_INPUT		0x02
#define TJI_SUBTYPE_ANALOG_OUTPUT		0x03
#define TJI_SUBTYPE_SERIAL_INPUT		0x04
#define TJI_SUBTYPE_SERIAL_OUTPUT		0x05
#define TJI_SUBTYPE_GENERIC_CONFIG		0x06
#define TJI_SUBTYPE_DEVICE_CONSOLE		0xFE

#define TJI_HEADER_LENGTH 2             // TJI header length (This is NOT the offset for the length byte)
#define TJI_LENGTH_BYTE_OFFSET  1       // Length offset is 1 b/c "[ID] [CNT] [TYPE]"
#define TJI_HEADER_FLAG   4             // offset in header for Flag byte

//TJI Flags
#define TJI_FLAG_BIT_MOD				0x01	//0 = List, 1 = Range
#define TJI_FLAG_BIT_ERROR				0x10	//0 = No errors,  1 = Errors
#define TJI_FLAG_BIT_UNSUP				0x20	//0 = Supported,  1 = Unsupported
#define TJI_FLAG_BIT_JRV				0x40	//0 = Full range exists, 1 = Join range violation
#define TJI_FLAG_BIT_MORE				0x80	//0 = Last packet, 1 = More packets to follow

//Misc TJI
#define TJI_PACKET_MAX_TOTAL_SIZE		80
#define TJI_PACKET_HEADER_SIZE			6
#define TJI_ENCAPSULATION_BYTES         3
#define TJI_PACKET_DATA_MAX_SIZE        (TJI_PACKET_MAX_TOTAL_SIZE - TJI_PACKET_HEADER_SIZE - TJI_ENCAPSULATION_BYTES)


///////////////////////////////////////////////////////////////////////////////

#endif
